#!/bin/sh
#
# Preupgrade Script for Cenon
# by Georg Fleischmann
#
# created:  2010-09-25
# modified: 2012-03-01 (fix in move library)
#           2012-02-06 (move "/Library/Cenon" -> "/Library/Application Support/Cenon")
#           2011-01-11 (exit 0, DSTROOT added)
#

# remove CAM module
[[ -d $DSTROOT/Applications/Cenon.app/Contents/Resources/CAM.bundle ]] &&
{
  rm -R $DSTROOT/Applications/Cenon.app/Contents/Resources/CAM.bundle;
}

# remove old receipts of Cenon (3.8)
if [ -d $DSTROOT/Library/Receipts/Cenon-3.8[0123].pkg ] ; then
  rm -R $DSTROOT/Library/Receipts/Cenon-3.8[0123].pkg
fi

# move "/Library/Cenon" -> "/Library/Application Support/Cenon" (3.10.0)
if [ -d "$DSTROOT/Library/Cenon" ] ; then
  if [ ! -d "$DSTROOT/Library/Application Support/Cenon" ] ; then
    mv "$DSTROOT/Library/Cenon" "$DSTROOT/Library/Application Support/"
  else	# Cenon-Library shouldn't exist in both locations
    echo "Warning: \"$DSTROOT/Library/Cenon\" should be removed ! This is in \"$DSTROOT/Library/Application Support/Cenon\" now"
    #rm -r "$DSTROOT/Library/Cenon"
  fi
fi

CEN_PATH="$DSTROOT/Library/Application Support/Cenon"

# remove old Cenon Examples (<= 3.9)
[[ -d "${CEN_PATH}/Examples/ai"      ]] && { rm -R "${CEN_PATH}/Examples/ai"   ; }
[[ -d "${CEN_PATH}/Examples/dxf"     ]] && { rm -R "${CEN_PATH}/Examples/dxf"  ; }
[[ -d "${CEN_PATH}/Examples/hpgl"    ]] && { rm -R "${CEN_PATH}/Examples/hpgl" ; }
[[ -d "${CEN_PATH}/Examples/pdf"     ]] && { rm -R "${CEN_PATH}/Examples/pdf"  ; }
[[ -d "${CEN_PATH}/Examples/ps"      ]] && { rm -R "${CEN_PATH}/Examples/ps"   ; }


exit 0
