/* EphemerisSearch.h
 * search Ephemeris data
 *
 * Copyright (C) 2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2004-04-12
 * modified: 2004-05-20
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_EPHEMERISSEARCH
#define VHF_H_EPHEMERISSEARCH

#include	"../Astro/SwissEphemeris.subproj/Ephemeris.h"

@interface EphemerisSearch:NSObject
{
    Ephemeris	*ephemeris;
}

+ newWithEphemeris:(Ephemeris*)eph;
- (id)initWithEphemeris:(Ephemeris*)eph;

/* composite search */
- (NSDictionary*)searchWithFeatures:(NSDictionary*)features
                           fromDate:(NSCalendarDate*)dateFrom toDate:(NSCalendarDate*)dateTo
                     searchInterval:(int)minutes;

/* search aspects */
- (NSDictionary*)searchAspect:(NSString*)planet1 :(NSString*)planet2
                     dividers:(NSArray*)dividers
                 searchAngles:(BOOL)searchAngles searchMirrors:(BOOL)searchMirrors
                     fromDate:(NSCalendarDate*)dateFrom toDate:(NSCalendarDate*)dateTo
               searchInterval:(int)minutes;

/* search transits */

@end

#endif	// VHF_H_EPHEMERISSEARCH
