/* astroCommon.h
 * Common astronomical functions
 *
 * Copyright (C) 1998-2005 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1998-11-06
 * modified: 2005-03-15
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROCOMMON
#define VHF_H_ASTROCOMMON

#define CALENDARFORMAT	@"%d.%m.%Y-%H:%M-%z"

float sunNode(int year);

NSMutableData* reducedTable(NSData *tableData, int tableSize, double factor);
NSMutableData* normalizedTable(NSData *table, int tableSize, BOOL positive);

double *harmonicTable(int tableSize);
double *harmonicPattern(int tableSize, int depth);
double harmonicValue(double deg);

//double iterationLimit( int div, int depth );
//double degIterated( double deg, int div, int depth );

//float comparableAngle180( float a, float ref);
//float angleFromFirstToSecond( float deg1, float deg2 );
//float angleBetween( float deg1, float deg2 );

NSString *stringFromDeg(float deg);
float degFromString(NSString *degString);

int sortAsNumbers(id str1, id str2, void *context);

float frac(float x);
NSCalendarDate *sideralTime(NSCalendarDate *gmt, float longitude);

float ra(NSCalendarDate *sideralTime);
float mc(NSCalendarDate *sideralTime);
NSCalendarDate *sideralTimeWithMC(float mcDeg, NSCalendarDate *utc);
float ac(NSCalendarDate *sideralTime, float latitude);

BOOL isAC(float lat, float acDeg, NSCalendarDate *sideralTime);
float longitudeForMC(float mcDeg, NSCalendarDate *sideralTime);
float latitudeForAC(float acDeg, NSCalendarDate *sideralTime);

NSString *planetSymbol(NSString *object);
NSString *nodeSymbol(NSString *planet);
NSString *zodiacSign(int sign);
NSString *aspectSymbol(float deg, float orb);

double standardAngle( double angle );
double angle(double deg1, double deg2);
double mirror(double deg1, double deg2);
double midpoint(double deg1, double deg2);
double harmony(double obj, double obj1, double obj2);


#endif // VHF_H_ASTROCOMMON
