/* APChart.m
 *
 * Copyright (C) 2001-2006 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2001-05-18
 * Modified: 2006-06-02
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_APCHART
#define VHF_H_APCHART

#include <AppKit/AppKit.h>
#include "APBasicLevel.h"

@interface APChart:APBasicLevel
{
    id	dbButton;
    id	nameField;
    id	cityField;
    id	latField;
    id	lonField;
    id	dateField;
    id	bcButton;

    id	compositeSwitch;
    id	cmpNameField;
    id	cmpCityField;
    id	cmpLatField;
    id	cmpLonField;
    id	cmpDateField;
    id	cmpBCButton;

    id			astroChart;	// the chart object
    NSMutableDictionary	*compositeEvent;
    NSTimer		*timer;		// clock timer
}

- (void)set:sender;
- (void)setClock:(id)sender;
- (id)astroChart;

- (void)openDatabase:sender;
- (void)setNow:sender;
- (void)setDate:sender;
- (void)setEvent:(NSDictionary*)dict;
- (NSString*)title;
- (NSString*)city;
- (float)latitude;
- (float)longitude;
- (NSCalendarDate*)date;
- (NSMutableDictionary*)data;
//- (NSDictionary*)eventData;

- (BOOL)composite;
- (void)setComposite:sender;
- (void)setCompositeDate:sender;
- (void)setCompositeEvent:(NSDictionary*)dict;
- (NSCalendarDate*)compositeDate;
- (NSDictionary*)compositeData;

@end

#endif	// VHF_H_APCHART
