/* AstroDate.m
 *
 * Copyright (C) 2006 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2006-01-15
 * modified: 2006-12-18
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <AppKit/AppKit.h>
#include <VHFShared/VHFDictionaryAdditions.h>
#include <VHFShared/vhfCommonFunctions.h>
#include "AstroDate.h"
#include "Astro.bproj/AstroController.h"

@implementation AstroDate

static AstroDate	*sharedInstance = nil;

#define ASTRO_BUNDLE	[NSBundle bundleForClass:[AstroDate class]]
#define DATE1_STRING	NSLocalizedStringFromTableInBundle(@"DD.MM.YYYY HH:MM ZON",  @"Astro", ASTRO_BUNDLE, NULL)
#define DATE2_STRING	NSLocalizedStringFromTableInBundle(@"YYYY-MM-DD HH:MM ZON",  @"Astro", ASTRO_BUNDLE, NULL)
#define DATE3_STRING	NSLocalizedStringFromTableInBundle(@"DD MON YYYY HH:MM ZON", @"Astro", ASTRO_BUNDLE, NULL)
#define ASTRO_DATEFORMATS	[NSArray arrayWithObjects: @"%d.%m.%Y", @"%Y-%m-%d", @"%d %b %Y", nil]
#define ASTRO_DATEMASKS		[NSArray arrayWithObjects: @"99.99.9999", @"9999-99-99", @"99 AAA 9999", nil]
#define ASTRO_DATEERRORS	[NSArray arrayWithObjects: DATE1_STRING, DATE2_STRING, DATE3_STRING, nil]


/* return human readable date format
 * "%Y-%m-%d" -> "YYYY-MM-DD"
 * created:  2006-01-15
 */
NSString *astroErrorDate(void)
{
    return [[AstroDate sharedInstance] errorString];
}

/* return identified date format of dateString or nil
 * created:  2006-01-15
 */
NSString *astroDateFormatForString(NSString *dateString)
{
    return [[AstroDate sharedInstance] dateFormatForString:dateString];
}


+ (id)sharedInstance
{
    if (!sharedInstance)
        sharedInstance = [[AstroDate alloc] init];
    return sharedInstance;
}

- (id)init
{
    [super init];
    dateFormats = [ASTRO_DATEFORMATS retain];
    dateMasks   = [ASTRO_DATEMASKS   retain];
    dateErrors  = [ASTRO_DATEERRORS  retain];
    monDict     = [[NSDictionary dictionaryWithObjectsAndKeys:
                   @"1", @"Jan",
                   @"2", @"Feb",
                   @"3", @"Mar",
                   @"4", @"Apr",
                   @"5", @"May",  @"5", @"Mai",
                   @"6", @"Jun",
                   @"7", @"Jul",
                   @"8", @"Aug",
                   @"9", @"Sep",
                  @"10", @"Oct", @"10", @"Okt",
                  @"11", @"Nov",
                  @"12", @"Dec", @"12", @"Dez", nil] retain];
    return self;
}

- (NSArray*)dateFormats	{ return dateFormats; }
- (NSArray*)dateMasks	{ return dateMasks;   }
- (NSArray*)dateErrors	{ return dateErrors;  }

- (NSString*)dateFormat	{ return Prefs_DateFormat; }

- (int)indexOfDateFormatForString:(NSString*)dateString
{   int		i, j;
    BOOL	checkPrefix = YES;

    for (i=0; i<[dateMasks count]; i++)
    {   NSString	*dateMask = [dateMasks objectAtIndex:i];

        if ( (checkPrefix && [dateString length] >= [dateMask length]) ||
             [dateString length] == [dateMask length] )
        {   BOOL	ok = NO;

            for (j=0; j<[dateMask length]; j++)	// test chars
            {   unsigned char	c = [dateString characterAtIndex:j];
                unsigned char	m = [dateMask   characterAtIndex:j];

                ok = NO;
                switch (m)
                {
                    case '9':
                        if (isdigit(c))
                            ok = YES;
                        break;
                    case 'A':
                        if (isalpha(c))
                            ok = YES;
                        break;
                    default:
                        if (m == c)
                            ok = YES;
                }
                if (!ok)
                    break;
            }
            if (ok)
                return i;
        }
    }
    return -1;
}

- (NSString*)dateFormatForString:(NSString*)dateString
{   int	ix = [self indexOfDateFormatForString:dateString];

    if (ix >= 0)
        return [dateFormats objectAtIndex:ix];
    return nil;
}

- (NSString*)errorString
{   NSString	*dateFormat  = Prefs_DateFormat;
    int		i;

    for (i=0; i<[dateFormats count]; i++)
        if ([dateFormat isEqual:[dateFormats objectAtIndex:i]])
            return [dateErrors objectAtIndex:i];
    NSLog(@"errorDate(): '%@' missing in allowed date formats!", dateFormat);
    return @"UNKNOWN";
}

/* get extracted year, month, day from string
 */
- (BOOL)getYear:(int*)y month:(int*)m day:(int*)d fromDateString:(NSString*)dateStr
{   int	ix = [self indexOfDateFormatForString:dateStr], i;

    *y = 2000, *m = 1, *d = 1;
    switch (ix)
    {
        case 0:	// DD.MM.YYYY
            *d = [[dateStr substringWithRange:NSMakeRange(0, 2)] intValue];
            *m = [[dateStr substringWithRange:NSMakeRange(3, 2)] intValue];
            *y = [[dateStr substringWithRange:NSMakeRange(6, 4)] intValue];
            break;
        case 1:	// YYYY-MM-DD
            *y = [[dateStr substringWithRange:NSMakeRange(0, 4)] intValue];
            *m = [[dateStr substringWithRange:NSMakeRange(5, 2)] intValue];
            *d = [[dateStr substringWithRange:NSMakeRange(8, 2)] intValue];
            break;
        case 2:	// DD MON YYYY
        {   NSString	*string;
            NSArray	*mons = [monDict allKeys];

            *d = [[dateStr substringWithRange:NSMakeRange(0, 2)] intValue];
            string = [dateStr substringWithRange:NSMakeRange(3, 3)];
            for (i=0; i<[mons count]; i++)
            {   NSString	*key = [mons objectAtIndex:i];

                if ([key rangeOfString:string options:NSCaseInsensitiveSearch].location == 0)
                {   *m = [monDict intForKey:key];
                    break;
                }
            }
            if (i >= [mons count])
                NSLog(@"[getYear:month:day: unknown month abbreviation '%@'", string);
            *y = [[dateStr substringWithRange:NSMakeRange(7, 4)] intValue];
            break;
        }
        default:
            return NO;
    }
    return YES;
}

- (void)dealloc
{
    if (self == sharedInstance)
        return;
    [dateFormats release];
    [dateMasks   release];
    [dateErrors  release];
    [super dealloc];
}

@end
