/* DocViewMap.h
 * Map Additions for DocView
 *
 * Copyright (C) 1998-2006 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1998-12-19
 * modified: 2006-02-19
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_DOCVIEWMAP
#define VHF_H_DOCVIEWMAP

#include "../Cenon/DocView.h"
#include "CIAMaps.subproj/CIAMap.h"

#define MAP_PREFIX	@"Map"	// the prefix of the filename of maps

@interface DocView(Map)

- (void)initMap;
- (BOOL)isMap;

- (void)setMapRadix:(NSEvent*)event;
//- (void)setCIAMap:(CIAMap*)amap;
- (CIAMap*)ciaMap;
- (void)createMapWithCenter:(NSPoint)center size:(NSSize)size grid:(float)gridSize
                   features:(NSDictionary*)features;

@end

#endif // VHF_H_DOCVIEWMAP
