/* Map.h
 * Commander of the map
 *
 * Copyrigth (C) 2003-2010 by Georg Fleischmann
 * Author:   Georg Fleischmann, Ilonka Fleischmann
 *
 * created:  2003-07-14
 * modified: 2006-05-31
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_MAPFUNCTIONS
#define VHF_H_MAPFUNCTIONS

#include <Foundation/Foundation.h>
#include "DocViewMap.h"

@interface Map:NSObject
{
    NSDictionary        *colors;	// object colors

    NSMutableDictionary *mapDict;	// map.plist
    NSString            *name;
    char                projectionType;	// 'M' = Mercator, 'S' = Stereographic, 'F' = Free style map
    NSPoint             origin;		// 0 lat/lon,      pole,                none
    double              scale;		// scale of the map (map unit = earth unit / scale)
    float               deg0;		// Stereo: angle of 0 meridian to horicontal axis
    NSDictionary        *freeGrid;	// Free: grid of positions
    NSRect              bounds;		// the useful bounds of the map
    NSString            *mapset;	// cia: filename of mapset
    NSPoint             center;
    NSSize              size;

    NSCalendarDate      *dateAxes;	// date of the last mapping of AC, MC
    NSCalendarDate      *mapDate;	// date of last loaded map
}

+ (Map*)mapWithMapDictionary:(NSDictionary*)dict;
- initWithContentsOfDictionary:(NSDictionary*)dict;

- (void)setBounds:(NSRect)rect;

/* query methods */
- (NSDictionary*)colors;	// return array with colors

/* projection */
- (NSPoint)latLonForPointOnMap:(NSPoint)mapP;
- (NSPoint)pointOnMapForLat:(float)lat lon:(float)lon;

/* mapping of AC, MC lines (axes) */
- (VGroup*)mapChartWithDate:(NSCalendarDate*)utc title:(NSString*)title inBounds:(NSRect)bounds;
- (NSCalendarDate*)date;
/* mapping of house tips */
- (VGroup*)mapHousesAtDate:(NSCalendarDate*)utc lat:(float)refLat lon:(float)refLon
                     title:(NSString*)title inBounds:(NSRect)viewBounds;
/* mapping of time tracks */
- (VGroup*)mapTimeTrackFromDate:(NSCalendarDate*)dateFr toDate:(NSCalendarDate*)dateTo
                                     forObjects:(NSArray*)objects earthRevolution:(BOOL)earthRev
                                          title:(NSString*)title inBounds:(NSRect)viewBounds;


/* cia map */
- (BOOL)needsCalculation;
- (NSMutableDictionary*)createMap;
- (CIAMap*)ciaMap;

/* load map */
- (void)displayMapAtDate:(NSCalendarDate*)mapDate inView:(DocView*)view;

/* archiving */
- (char)projectionType;
- (void)setFreeGrid:(NSDictionary*)grid;
- (void)writeInfoToFile:(NSString*)file;

@end

#endif // VHF_H_MAPFUNCTIONS
