/* AstroChart.h
 * The well known circular Astrology chart
 *
 * Copyright (C) 2001-2011 by Georg Fleischmann
 * Author:   Georg Fleischmann
 *
 * created:  2001-11-07
 * modified: 2006-07-29
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROCHART
#define VHF_H_ASTROCHART

#include <AppKit/AppKit.h>
#include "DocViewAstro.h"

#define CHART_PREFIX	@"Chart"            // the prefix of the filename of charts

/* table dimensions
 */
typedef enum
{
    CHART_ZODIAC      =   1,
    CHART_CENTER      =   2,                // center star
    CHART_SCALE       =   4,
    CHART_OBJECTS     =   8,
    CHART_ASPECTLINES =  16,
    CHART_DECLINATION =  32,
    CHART_HOUSES      =  64,
    CHART_TOPOSCALE   = 128,
    CHART_STAR        = 256,
    CHART_WAVE        = 512,
    CHART_ALL         = 0xFFFF              // all components
} ChartComponents;
#define MAX_CHARTINTERVALS	20
typedef struct
{
    /* chart */
    NSPoint		center, centerC;            // chart positions
    NSPoint		start, startC;              // start of charts
    float		radius, radiusC;            // radius of charts (scale radius)
    float		radiusMax;                  // outer radius of chart (ecliptic signs)
    NSPoint		table, tableC;              // table positions
    NSPoint		info;                       // info text
    /* interval charts */
    NSPoint		centerI[MAX_CHARTINTERVALS];    // interval chart positions
    NSPoint		startI[MAX_CHARTINTERVALS];     // interval chart start
    float		radiusI[MAX_CHARTINTERVALS];    // interval chart radius
    /* components */
    ChartComponents	components;             // chart components
    ChartComponents	componentsInt;          // chart components interval charts
    /* layer indexes */
    int			layerMask;                  // layer index of mask
    int			layerChart;                 // layer index of chart
    int			layerMaskC;                 // layer index of mask  composite
    int			layerChartC;                // layer index of chart composite
}ChartTemplate;

@interface AstroChart:NSObject
{
    DocView         *view;
    id              ephemeris;
    int             ixComposite, ixMaskComposite;   // DEPRECATED, use chartTemplate.layer*
    ChartTemplate   chartTemplate;
    NSString        *astroFont;

    int             divider;                // divider for modulo chart
    NSDictionary    *dividerDict;
}

+ (id)astroChartWithView:(DocView*)aView;
- (id)initWithView:(DocView*)aView;
- (void)setView:(id)newView;
- (id)view;
- (void)setDivider:(int)div;                // set divider for modulo chart
- (void)setObjDividers:(NSDictionary*)dict; // set dividers for modulo chart
- (ChartTemplate)chartTemplate;

- (void)setCompositeLayerEnabled:(BOOL)enabled;
- (void)radix:(NSCalendarDate*)gmt
    longitude:(float)longitude latitude:(float)latitude city:(NSString*)city
        title:(NSString*)title composite:(NSDictionary*)composite;

/* Detail drawing */
- (void)addHousesAtCenter:(NSPoint)cp radius:(float)radius radiusCenter:(float)radCenter
                     date:(NSCalendarDate*)gmt lat:(float)lat lon:(float)lon
                 rotateAC:(float)rotateAC toLayer:(LayerObject*)layer;

@end

#endif // VHF_H_ASTROCHART
