/* EventManager.h
 *
 * Copyright (C) 2003-2010 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-06-22
 * modified: 2010-01-16 (allow moving/resizing in grid)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_EVENTMANAGER
#define CEN_H_EVENTMANAGER

#include <AppKit/AppKit.h>

#define AstroUpdateEvent	@"AstroUpdateEvent"

#define TYPEPOPUP_UNKNOWN	0
#define TYPEPOPUP_FEMALE	1
#define TYPEPOPUP_MALE		2
#define TYPEPOPUP_ORG		3
#define TYPEPOPUP_COUNTRY	4
#define TYPEPOPUP_EVENT		5

@interface EventManager:NSObject
{
    id	eventPanel;
    id	eventBrowser;

    id	folderField;
    id	removeFolderButton;

    id	typePopup;
    id	eventField;
    id	dateField;
    id	timeField;
    id	tzField;
    id	bcSwitch;
    id	countryField;
    id	cityField;
    id	latField;
    id	lonField;
    id	textView;
    id	addButton;
    id	modifyButton;
    id	removeButton;
    id	setCompositeButton;

    NSMutableDictionary	*eventDict;
    NSMutableDictionary *extEventDict;
    NSMutableArray	*folders;
}

/* action methods */
- (void)showPanel:sender;

- (void)addFolder:sender;
- (void)renameFolder:sender;
- (void)removeFolder:sender;

- (void)getLocation:sender;
- (void)getTimeZone:sender;

- (void)clear:sender;
- (void)modify:sender;
- (void)add:sender;
- (void)remove:sender;
- (void)search:sender;

- (void)set:sender;

@end

#endif	// CEN_H_EVENTMANAGER
