/* AspectLines.h
 * This calculates the traditional aspect lines
 *
 * Copyright (C) 2006 by Georg Fleischmann
 * Author:   Georg Fleischmann
 *
 * created:  2006-04-11
 * modified: 2006-05-01
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_ASPECTLINES
#define CEN_H_ASPECTLINES

#include <AppKit/AppKit.h>

#define MAX_DIVIDER	50

@interface AspectLines:NSObject
{
    int		divider[MAX_DIVIDER];	// integer dividers
    int		dividerCnt;
    NSArray	*dividerColors;		// colors of dividers

    BOOL	showMirrors;		// whether to display mirror aspects
    BOOL	showStrengthOfOrb;	// whether to show the strength of orb
    BOOL	showColoredDividers;	// whether to use colors for aspects
    NSArray	*colors;		// aspect colors

    float	radius;			// the radius of the circle we operate
    float	saturation;		// color saturation
    float	orb;			// relative orb (factor of aspect) [0, 1.0], default = 5%
    float	maxOrbWidth;		// maximum line width for showing strength of orb

    double	*objects;		// the degrees we work with
    int		objectCnt;
}

+ (id)sharedInstance;

- (void)setDividersFromString:(NSString*)divStr;
- (void)setDisplayMirrors:(BOOL)mirrorFlag;

- (void)setStrengthOfOrb:(BOOL)flag;
- (void)setColoredDividers:(BOOL)flag;
- (void)setColorSaturation:(float)s;

- (void)setRadius:(float)radius;
- (void)setObjects:(double*)newObjs cnt:(int)oCnt;
- (void)setOrb:(float)newOrb;

- (VGroup*)calculateAtCenter:(NSPoint)center;

@end

#endif // CEN_H_ASPECTLINES
