/* AstroController.h
 *
 * Copyright (C) 1999-2015 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2003-03-23
 * Modified: 2015-08-17 (periSwitches added)
 *           2015-01-26 (equatorial positions added)
 *           2014-11-21 (heliocentric position added)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_PREFASTROCONTROLLER
#define CEN_H_PREFASTROCONTROLLER

#include <AppKit/AppKit.h>
#include "../../Cenon/PreferencesPanel.subproj/PreferencesMethods.h"

#define Prefs_ShowAstroPanel	( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroShowPanel"]     isEqual:@"YES"]) ? YES : NO )
#define Prefs_Colorful          ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroColorful"]      isEqual:@"YES"]) ? YES : NO )
#define Prefs_DegreesMinutes	( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroDegreesMinutes"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_FractalScale      ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroFractalScale"]  isEqual:@"YES"]) ? YES : NO )

#define Prefs_Topocentric       ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroTopocentricPosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_Heliocentric      ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroHeliocentricPosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_Equatorial        ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroEquatorialPosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_MeanNodes         ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroMeanNodes"] isEqual:@"YES"]) ? YES : NO )

#define Prefs_ShowRetrograde	( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroShowRetrograde"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowHousePosition	( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroShowHousePosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowHouseSize     ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroShowHouseSize"] isEqual:@"YES"]) ? YES : NO )
/*#define Prefs_ShowHouseMaxima	( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroShowHouseMaxima"] isEqual:@"YES"]) ? YES : NO )*/
#define Prefs_LocalScale        ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroLocalScale"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_HouseDegrees      ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroHouseDegrees"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowDeclination	( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroShowDeclination"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowAspectGeo     ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroShowAspectGeo"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ACFix             ( ([[[NSUserDefaults standardUserDefaults] \
                                    objectForKey:@"astroACFix"] isEqual:@"YES"]) ? YES : NO )

#define Prefs_BGColor		vhfRGBColorFromString([[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroBGColor"])
#define Prefs_DateFormat	[[NSUserDefaults standardUserDefaults] objectForKey:@"astroDateFormat"]
#define Prefs_AstroFont		[[NSUserDefaults standardUserDefaults] objectForKey:@"astroFont"]
#define Prefs_Objects		[[NSUserDefaults standardUserDefaults] objectForKey:@"astroObjects"]
#define Prefs_Nodes         [[NSUserDefaults standardUserDefaults] objectForKey:@"astroNodes"]
#define Prefs_Peri          [[NSUserDefaults standardUserDefaults] objectForKey:@"astroPeri"]
#define Prefs_AstroInterval	[[[NSUserDefaults standardUserDefaults] objectForKey:@"astroInterval"] intValue]

/* switches in generalSwitches */
typedef enum
{
    SWITCH_SHOWASTROPANEL  =  0,
    SWITCH_COLORFUL        =  1,	// use colors for house tips etc.
    SWITCH_DEGREESMINUTES  =  2,    // degree notation: 123.45 / degree, minutes, seconds
    SWITCH_FRACTALSCALE    =  3     // Fractal Edition: display fractions, not degrees
}AstroGeneralSwitches;

/* switches in objectSwitches */
typedef enum
{
    SWITCH_TOPOCENTRIC	   =  0,	// topocentric  planet positions (at location on earth)
    SWITCH_HELIOCENTRIC	   =  1,	// heliocentric planet positions (sun at the center)
    SWITCH_EQUATORIAL      =  2,    // equatorial positions (instead of ecliptical)
    SWITCH_MEANNODES       =  3		// mean nodes instead of true nodes
}AstroObjectsSwitches;

/* switches in chartSwitches */
typedef enum
{
    SWITCH_SHOWRETROGRADE  =  0,
    SWITCH_SHOWHOUSEPOS    =  1,	// house degrees
    SWITCH_SHOWHOUSESIZE   =  2,	// display size of house
    //SWITCH_SHOWHOUSEMAXIMA =  2,	// mark maxima of house
    SWITCH_LOCALSCALE      =  3,	// topocentric degree scale
    SWITCH_HOUSEDEGREES	   =  4,	// planet positions relative houses
    SWITCH_SHOWDECLINATION =  5,
    SWITCH_SHOWASPECTGEO   =  6,	// aspect lines
    SWITCH_ACFIX           =  7		// AC rotated to the left
}AstroChartSwitches;

/* Objects */
#define OBJECTS_1		[NSArray arrayWithObjects: \
                                  @"Sun", @"Moon", @"Mercury", @"Venus", @"Mars", \
                                  @"Jupiter", @"Saturn", @"Uranus", @"Neptune", @"Pluto", nil]
#define OBJECTS_2		[NSArray arrayWithObjects: \
                                  @"Node", @"True Node", @"Apogee", @"True Apogee", \
                                  @"Chiron", @"Pholus", @"Ceres", @"Pallas", @"Juno", @"Vesta", nil]

/* notifications */
#define AstroPrefsCallToAddItemsNotification    @"AstroPrefsCallToAddItems"	// modules should add their panes
#define AstroPrefsAddItemNotification           @"AstroPrefsAddItem"		// we have to add a new item

@interface AstroController:NSObject <PreferencesMethods>
{
    /* Preferences Pane */
    IBOutlet NSBox      *box;               // the Astro Preferences box
    IBOutlet NSBox      *subBox;            // the box for sub-modules
    IBOutlet NSMatrix   *menuMatrix;        // the menu items

    /* General */
    IBOutlet NSBox      *boxGeneral;
    IBOutlet NSMatrix   *generalSwitches;   // the switches
    IBOutlet id         datePopup;          // the date format popup
    IBOutlet id         fontPopup;          // the font popup

    /* Objects */
    IBOutlet NSBox      *boxObjects;
    IBOutlet NSMatrix   *objectSwitches;     // switch options for objects
    IBOutlet NSMatrix   *object1Switches;    // planets
    IBOutlet NSMatrix   *nodeSwitches;       // planet nodes
    IBOutlet NSMatrix   *periSwitches;       // planet perihelion
    IBOutlet NSMatrix   *object2Switches;    // moon nodes and asteroids

    /* Chart */
    IBOutlet NSBox      *boxChart;          // the view with the chart preferences
    IBOutlet id         bgColorWell;        // color well for background color
    IBOutlet NSMatrix   *chartSwitches;     // the chart switches
    IBOutlet id         chartIntervalField; // time interval

    /* Map */
    //id boxMap;	// the view with the map preferences

    NSMutableArray      *prefViews; // preferences modules (boxGeneral, boxObjects, boxChart, ...)
}

- (id)generalSwitches;                  // for outside access

- (IBAction)set:sender;
- (IBAction)setGeneral:sender;
- (IBAction)setObjects:sender;
- (IBAction)setChart:sender;
//- (IBAction)setMap:sender;

- (IBAction)setLevel:sender;

@end

#endif // CEN_H_PREFASTROCONTROLLER
