/* DocViewAstro.m
 * Astrology Additions for DocView.m
 *
 * Copyright (C) 1998-2014 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1998-12-19
 * modified: 2006-04-21 (clean up: text functions moved to VTextAstroAdditions)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#include <AppKit/AppKit.h>
#include <math.h>
#include "../Cenon/App.h"
#include "../Cenon/DocWindow.h"
#include "VTextAstroAdditions.h"	// convenient text methods
#include "DocViewAstro.h"
#include "astroCommon.h"
#include "SwissEphemeris.subproj/Ephemeris.h"

/* Private methods
 */
@interface DocView(PrivateMethods)
@end

@implementation DocView(Astro)

/* Astrology Methods of the GraphicView. */

- (void)setCrossAt:(NSPoint)p layer:(int)layer
{   VLine	*line;
    NSPoint	p0, p1;

    line = [[[VLine allocWithZone:[self zone]] init] autorelease];
    p0 = NSMakePoint(p.x-5.0, p.y-5.0);
    p1 = NSMakePoint(p.x+5.0, p.y+5.0);
    [line setVertices:p0 :p1];
    [[[layerList objectAtIndex:layer] list] addObject:line];
    line = [[[VLine allocWithZone:[self zone]] init] autorelease];
    p0 = NSMakePoint(p.x-5.0, p.y+5.0);
    p1 = NSMakePoint(p.x+5.0, p.y-5.0);
    [line setVertices:p0 :p1];
    [[[layerList objectAtIndex:layer] list] addObject:line];
}

/* we add 4 min per degree (East)
 */
- (NSCalendarDate*)localTime:(NSCalendarDate*)gmt longitude:(float)l
{   NSCalendarDate	*date;

    date = [gmt dateByAddingYears:0 months:0 days:0 hours:0 minutes:0 seconds:(int)(l*240.0)];
//NSLog(@"gmt:%@ long:%f localTime:%@", gmt, l, date);
    return date;
}

/* MJD: modified julian date
 */
- (double)mjd:(NSCalendarDate*)date
{   int		year, month, day;
    double	hour, mjd;
    double	a, b;

    year = [date yearOfCommonEra];
    month = [date monthOfYear];
    day = [date dayOfMonth];
    hour = (double)[date hourOfDay]+[date minuteOfHour]/60.0+[date secondOfMinute]/3600.0;

    a = 10000.0*year+100.0*month+day;
    if ( month<=2 )
    {
        month += 12;
        year--;
    }
    if ( a<=15821004.1 )
        b = -2.0+floor((year+4716.0)/4.0)-1179.0;
    else
        b = floor(year/400.0)-floor(year/100.0)+floor(year/4.0);
    a = 365.0*year-679004.0;
    mjd = a+b+floor(30.6001*(month+1.0))+day+hour/24.0;
    return mjd;
}

/* probleme mit stunden: 01.11.1950 stimmt, 01.11.1950-20:00 stimmt nicht beim zurckwandeln, day ist schon falsch
 */
- (NSCalendarDate*)dateFromMJD:(double)mjd
{   int			year, month, day, hour, min, sec;
    int			b, d, f;
    double		jd, jd0, c, e;
    NSCalendarDate	*date;

    jd = mjd+2400000.5;
    jd0 = floor(jd+0.5);
    if ( jd0<2299161.0 )
        c = jd0+1524.0;
    else
    {
        b = floor((jd0-1867216.25)/36524.25);
        c = jd0+(b-floor(b/4.0))+1525.0;
    }
    d = floor((c-122.1)/365.25);
    e = 365.0*d+floor(d/4.0);
    f = floor((c-e)/30.6001);
    day = floor(c-e+0.5)-floor(30.6001*f);
    month = f-1-12*floor(f/14.0);
    year = d-4715-floor((7.0+month)/10.0);
    hour = 24.0*(jd+0.5-jd0);
    min = (24.0*(jd+0.5-jd0) - hour)/60.0;
    sec = ((24.0*(jd+0.5-jd0) - hour) - min*60.0)/3600.0;

    date = [NSCalendarDate dateWithYear:year month:month day:day hour:hour minute:min second:sec
                               timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0]];
    return date;
}

- (NSCalendarDate*)sideralTime:(NSCalendarDate*)gmt longitude:(float)longitude
{
    return sideralTime(gmt, longitude);
#if 0
   double	mjd, mjd0, t, ut, gmst, lmst;

    longitude = -longitude;

    //mjd = [self mjd:gmt];
//NSLog(@"gmt:%@ gmt1:%@", gmt, [self dateFromMJD:mjd]);

    mjd = floor([self mjd:gmt]);

    mjd0 = floor(mjd);
    ut = (mjd-mjd0)*24;
    t = (mjd0-51544.5)/36525.0;
    gmst = 6.697374558+1.0027379093*ut+(8640184.812866+(0.093104-6.2e-6*t)*t)*t/3600.0;
    lmst = 24.0*frac((gmst-longitude/15.0)/24.0);

    return [gmt dateByAddingYears:0 months:0 days:0 hours:0 minutes:0 seconds:lmst*3600.0];
#endif
}

- (float)mc:(NSCalendarDate*)sideralTime
{   float	s, e = 23.4333, l, mc, ra;

    s = [sideralTime timeIntervalSinceDate:[NSCalendarDate dateWithString:[sideralTime descriptionWithCalendarFormat:@"%Y.%m.%d-00:00-%z"] calendarFormat:@"%Y.%m.%d-%H:%M-%z"]];
    ra = s / (4.0*60.0);
    l = Cos(e)*Cot(ra);
    mc = Acot(l);
    if ( mc<0 )
        mc += 360.0;

    /* from 12:00 - 00:00 sideralTime -> mc = 180 - 360 degree
     * from 00:00 - 12:00 sideralTime -> mc = 0 - 180 degree
     * -06:00 -> mc
     * 06:00- -> mc -= 180.0
     */
    if ( s>=0 && s<43200 )
    {
        if ( mc>180.0 )
            mc -= 180.0;
    }
    else if ( mc<180.0 )
        mc += 180.0;

//NSLog(@"sideral:%@ ra:%f mc:%f", sideralTime, ra, mc);
    return mc;
}

- (float)ac:(NSCalendarDate*)sideralTime latitude:(float)lat
{   float	s, l, e = 23.4333, ac, oa;

    s = [sideralTime timeIntervalSinceDate:[NSCalendarDate dateWithString:[sideralTime descriptionWithCalendarFormat:@"%Y.%m.%d-00:00-%z"] calendarFormat:@"%Y.%m.%d-%H:%M-%z"]];
    oa = s / (4.0*60.0) + 90.0;
    l = Cos(e)*Cot(oa) - Sin(e)*Tan(lat)/Sin(oa);
    ac = Acot(l);
    if ( ac<0 )
        ac += 360.0;
    /* from 18:00 - 06:00 sideralTime -> ac = 0 - 180 degree
     * from 06:00 - 18:00 sideralTime -> ac = 180 - 360 degree
     */
    if ( s>=21600 && s<64800 )
    {
        if ( ac<180.0 )
            ac += 180.0;
    }
    else if ( ac>180.0 )
        ac -= 180.0;
//NSLog(@"sideral:%@ %.0f:%.0f l:%f ac:%f", sideralTime, s/3600.0, (s-3600.0*floor(s/3600.0))/60.0, l, ac);
    return ac;
}

@end
