/* VTextAstroAdditions.m
 * convenient text methods
 *
 * Copyright (C) 1999-2015 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1999-06-11
 * modified: 2006-04-21
 *
 * This file is part of the Cenon Astro module.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#include "VTextAstroAdditions.h"

@implementation VText(VTextAstroAdditions)

/* text with box origin (not base!) at given position (p)
 */
+ (VText*)text:(NSString*)string                // the string
        origin:(NSPoint)p                       // origin of text box (unrotated)
         color:(NSColor*)col                    // text color
         angle:(float)angle center:(NSPoint)cp  // rotation angle + center
    lineHeight:(float)lineHeight                // line height
         align:(NSTextAlignment)mode            // alignment
          font:(NSFont*)fnt                     // font
{   VText	*text = [VText textGraphic];
    NSRect	r;

    [text setString:string font:fnt lineHeight:lineHeight color:col];
    r = [text textBox];
    r.size.height += 0.5;	// workaround [NSTextView sizeToFit]
    [text setTextBox:r];

    //if (mode != NSLeftTextAlignment)
    //    [text setAlignment:mode];
    r = [text bounds];
    if (mode == NSRightTextAlignment)
        p.x -= r.size.width;
    else if ( mode == NSCenterTextAlignment)
        p.x -= r.size.width / 2.0;

    vhfRotatePointAroundCenter(&p, cp, angle);
    [text moveTo:p];
    return text;
}


/* text (all parameters) */
+ (VText*)text:(NSString*)string                // string
          base:(NSPoint)p                       // base line position
         color:(NSColor*)col                    // text color
         angle:(float)angle center:(NSPoint)cp	// rotation angle and center
    lineHeight:(float)lineHeight                // line height
         align:(NSTextAlignment)mode            // alignment
          font:(NSFont*)fnt                     // font
{   VText	*text = [VText textGraphic];
    NSRect	r;

    [text setString:string font:fnt lineHeight:lineHeight color:col];

    //if (mode != NSLeftTextAlignment)
    //    [text setAlignment:mode];
    r = [text bounds];
    if (mode == NSRightTextAlignment)
        p.x -= r.size.width;
    else if ( mode == NSCenterTextAlignment)
        p.x -= r.size.width / 2.0;

    [text setBaseOrigin:p];
    vhfRotatePointAroundCenter(&p, cp, angle);
    return text;
}

/* text (default line height) */
+ (VText*)text:(NSString*)string                // string
          base:(NSPoint)p                       // base line position
         color:(NSColor*)col                    // text color
         angle:(float)angle center:(NSPoint)cp  // rotation angle and center
         align:(NSTextAlignment)mode            // text alignment
          font:(NSFont*)fnt
{
    return [VText text:string base:p color:col
                 angle:angle center:cp
            lineHeight:0.0 align:mode font:fnt];
}

/* text (left aligned) */
+ (VText*)text:(NSString*)string
          base:(NSPoint)p                       // base line position of text
         color:(NSColor*)col
         angle:(float)angle center:(NSPoint)cp
    lineHeight:(float)lineHeight                // line height
          font:(NSFont*)fnt
{
    return [VText text:string base:p color:col
                 angle:angle center:cp
            lineHeight:lineHeight align:NSLeftTextAlignment font:fnt];
}

/* text (default line height, left aligned) */
+ (VText*)text:(NSString*)string
          base:(NSPoint)p			// base line position of text
         color:(NSColor*)col
         angle:(float)angle center:(NSPoint)cp
          font:(NSFont*)fnt
{
    return [VText text:string base:p color:col
                 angle:angle center:cp
            lineHeight:0.0 align:NSLeftTextAlignment font:fnt];
}


/* centered text */
+ (VText*)text:(NSString*)string        // string
        center:(NSPoint)p               // center position of text box
         color:(NSColor*)col            // text color
         angle:(float)angle center:(NSPoint)cp  // rotation angle and center
    lineHeight:(float)lineHeight        // line height
          font:(NSFont*)fnt             // font
{   VText	*text = [VText textGraphic];
    NSRect	r;

    //[text setFont:fnt];
    [text setString:string font:fnt lineHeight:lineHeight color:col];
  //  [text setString:string];
  //  [text setFont:fnt];
  //  [text sizeToFit];
    //[text setRotAngle:angle];
    vhfRotatePointAroundCenter(&p, cp, angle);
    r = [text bounds];
    p.x -= r.size.width  / 2.0;
    p.y -= r.size.height / 2.0;
    [text moveTo:p];

    r = [text bounds];
    r.size.width  += 0.5;	// size needs to be a little more than what sizeToFit does
    r.size.height += 0.5;
    [text setTextBox:r];
 //   if (! [col isEqual:[NSColor blackColor]])
 //       [text setColor:col];
    return text;
}

/* centered text (default line height) */
+ (VText*)text:(NSString*)string
        center:(NSPoint)p                       // center of text box
         color:(NSColor*)col
         angle:(float)angle center:(NSPoint)cp  // rotation angle and center
          font:(NSFont*)fnt
{
    return [VText text:string center:p color:col
                 angle:angle center:cp
            lineHeight:0.0 font:fnt];
}

/* centered text (horicontal) */
+ (VText*)text:(NSString*)string
        center:(NSPoint)p
         color:(NSColor*)col
          font:(NSFont*)fnt
{   VText	*text = [VText textGraphic];
    NSRect	r;

    [text setString:string font:fnt lineHeight:0.0 color:col];
    r = [text bounds];
    p.x -= r.size.width  / 2.0;
    p.y -= r.size.height / 2.0;
    [text moveTo:p];
    return text;
}

/* centered rotated text */
+ (VText*)text:(NSString*)string                // string
        center:(NSPoint)p                       // center position of text box
         color:(NSColor*)col                    // text color
      rotAngle:(float)angle center:(NSPoint)cp  // rotation angle and center - text itself is rotated
          font:(NSFont*)fnt                     // font
{   VText	*text = [VText textGraphic];
    NSRect	r;

    [text setString:string font:fnt lineHeight:0.0 color:col];
    r = [text bounds];
    p.x -= r.size.width  / 2.0;
    p.y -= r.size.height / 2.0;
    [text moveTo:p];

    r = [text bounds];
    r.size.width  += 0.5;	// size needs to be a little more than what sizeToFit does
    r.size.height += 0.5;
    [text setTextBox:r];

    [text setAngle:angle withCenter:cp];

    return text;
}

@end
