/* astroMessages.h
 * common bundle messages
 *
 * Copyright (C) 2003-2010 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-06-22
 * modified: 2006-05-10
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_ASTROMESSAGES
#define CEN_H_ASTROMESSAGES

#define ASTRO_BUNDLE                [NSBundle bundleForClass:[AstroPrincipal class]]
#define VHFLocalAstroString(key)    NSLocalizedStringFromTableInBundle(key, @"Astro", ASTRO_BUNDLE, NULL)

/* Preferences */
#define PREF_GENERAL_TITLE		VHFLocalAstroString(@"General")

/* General */
#define DEGREE_FORMAT			VHFLocalAstroString(@"%@ %@'%@\"")
#define REALLYMODIFY_STRING		VHFLocalAstroString(@"Do you really want to modify '%@' ?")

/* Astro Panel: Tabs */
#define TABCHART_STRING			VHFLocalAstroString(@"Chart")
#define TABMAP_STRING			VHFLocalAstroString(@"Map")
#define TABSEARCH_STRING		VHFLocalAstroString(@"Search")
#define TABFLOWCHART_STRING		VHFLocalAstroString(@"Flow Chart")

/* Flow Chart */

/* Event Manager */
#define REALLYDELETEFOLDER_STRING	VHFLocalAstroString(@"Do you really want to remove the folder '%@' ?")
#define REALLYDELETEEVENT_STRING	VHFLocalAstroString(@"Do you really want to remove the event '%@' ?")
#define WRONGDATEFORMAT_STRING		VHFLocalAstroString(@"Please specify the date in the format '%@'")

/* City Manager */
#define REALLYDELETECITY_STRING		VHFLocalAstroString(@"Do you really want to remove the city '%@' ?")

#endif // CEN_H_ASTROMESSAGES
