/* VTextAstroAdditions.h
 * convenient text methods
 *
 * Copyright (C) 1999-2006 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1999-06-11
 * modified: 2006-05-24
 *
 * This file is part of the Cenon Astro module.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_VTEXTASTROADDITIONS
#define CEN_H_VTEXTASTROADDITIONS

#include "../Cenon/GraphicObjects.subproj/VText.h"

@interface VText(VTextAstroAdditions)

/* text with box origin */
+ (VText*)text:(NSString*)string            // the string
        origin:(NSPoint)p                   // origin of text box
         color:(NSColor*)color              // text color
         angle:(float)angle center:(NSPoint)cp	// rotation angle + center
    lineHeight:(float)lineHeight            // line height
         align:(NSTextAlignment)mode		// alignment
          font:(NSFont*)font;               // font


/* text (all parameters) */
+ (VText*)text:(NSString*)string            // string
          base:(NSPoint)p                   // base line position
         color:(NSColor*)color              // text color
         angle:(float)angle center:(NSPoint)cp	// rotation angle and center
    lineHeight:(float)lineHeight            // line height
         align:(NSTextAlignment)mode		// alignment
          font:(NSFont*)font;               // font

/* text (default line height) */
+ (VText*)text:(NSString*)string            // string
          base:(NSPoint)p                   // base line position
         color:(NSColor*)color              // text color
         angle:(float)angle center:(NSPoint)cp	// rotation angle and center
         align:(NSTextAlignment)mode		// text alignment
          font:(NSFont*)font;

/* text (left aligned) */
+ (VText*)text:(NSString*)string
          base:(NSPoint)p                   // base line position of text
         color:(NSColor*)color
         angle:(float)angle center:(NSPoint)cp
    lineHeight:(float)lineHeight            // line height
          font:(NSFont*)font;

/* text (default line height, left aligned) */
+ (VText*)text:(NSString*)string
          base:(NSPoint)p                   // base line position of text
         color:(NSColor*)color
         angle:(float)angle center:(NSPoint)cp
          font:(NSFont*)font;


/* centered text */
+ (VText*)text:(NSString*)string            // string
        center:(NSPoint)p                   // center position of text box
         color:(NSColor*)color              // text color
         angle:(float)angle center:(NSPoint)cp	// rotation angle and center
    lineHeight:(float)lineHeight            // line height
          font:(NSFont*)font;               // font

/* centered text (default line height) */
+ (VText*)text:(NSString*)string
        center:(NSPoint)p                   // center of text box
         color:(NSColor*)color
         angle:(float)angle center:(NSPoint)cp	// rotation angle and center
          font:(NSFont*)font;

/* centered text (horicontal) */
+ (VText*)text:(NSString*)string
        center:(NSPoint)p
         color:(NSColor*)color
          font:(NSFont*)font;

/* centered rotated text */
+ (VText*)text:(NSString*)string            // string
        center:(NSPoint)p                   // center position of text box
         color:(NSColor*)col                // text color
      rotAngle:(float)angle center:(NSPoint)cp	// rotation angle and center - text itself is rotated
          font:(NSFont*)fnt;                // font

@end

#endif // CEN_H_VTEXTASTROADDITIONS
