/* vhf2DFunctions.h
 * vhf 2-D graphic functions
 *
 * Copyright (C) 1996-2003 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1996-01-19
 * modified: 2003-07-19
 *
 * This file is part of the vhf Shared Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by the vhf interservice GmbH. Among other things,
 * the License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this library; see the file LICENSE. If not, write to vhf.
 *
 * If you want to link this library to your proprietary software,
 * or for other uses which are not covered by the definitions
 * laid down in the vhf Public License, vhf also offers a proprietary
 * license scheme. See the vhf internet pages or ask for details.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_2DFUNCTIONS
#define VHF_H_2DFUNCTIONS

//#include <AppKit/NSGraphics.h>
#include "types.h"

#define	SqrDistPoints(p1, p2)	(((p1).x-(p2).x)*((p1).x-(p2).x)+((p1).y-(p2).y)*((p1).y-(p2).y))
/* #define	SqrDistPoints(p1, p2)	( ((double)(p1).x-(double)(p2).x)*((double)(p1).x-(double)(p2).x) \
                                + ((double)(p1).y-(double)(p2).y)*((double)(p1).y-(double)(p2).y) ) */

float distancePointLine(const NSPoint *p0, const NSPoint *p1, const NSPoint *point);
float sqrDistancePointLine(const NSPoint *p0, const NSPoint *p1, const NSPoint *point);
double sqrDistPointRect(NSPoint p, NSRect rect);
float pointOnLineClosestToPoint(NSPoint p0, NSPoint p1, NSPoint point, NSPoint *iPoint);
NSPoint pointMirroredAtAxis(NSPoint p, VHFLine axis);
int vhfIntersectVectors(NSPoint p0, NSPoint da, NSPoint p1, NSPoint db, NSPoint *p);
int vhfIntersectVectorAndRect(NSPoint p0, NSPoint d0, NSRect rect, NSPoint *pts);
int vhfIntersectLines(NSPoint *pArray, NSPoint p0, NSPoint p1, NSPoint pl0, NSPoint pl1);
int vhfIntersectLineAndRect(NSPoint p0, NSPoint p1, NSRect rect, NSPoint *pts);
BOOL vhfIntersectsRect(NSRect rect1, NSRect rect2);
BOOL vhfIsPointInsidePolygon(NSPoint p, NSPoint *pts, int nPts);
BOOL vhfContainsRect(NSRect rect1, NSRect rect2);
NSPoint vhfPointRotatedAroundCenter(NSPoint p, float a, NSPoint cp);	// ccw
void vhfRotatePointAroundCenter(NSPoint* p, NSPoint cp, float a);	// ccw
void sortPointArray(NSPoint *pArray, int cnt, NSPoint p0);
void vhfSortValues(float *vArray, int cnt, float v0);
NSRect vhfBoundsOfPoints(NSPoint *pts, int nPts);
BOOL pointInArray(NSPoint point, const NSPoint *array, int cnt);
BOOL pointWithToleranceInArray(NSPoint point, float tol, const NSPoint *array, int cnt);
BOOL valueInArray(int val, int* array, int cnt);
int removePointFromArray(NSPoint p, NSPoint *pArray, int cnt);
int removePointWithToleranceFromArray(NSPoint p, float tol, NSPoint *pArray, int cnt);
int vhfFilterPoints(NSPoint *pArray, int cnt, float tol);

float vhfAngleOfPointRelativeCenter(NSPoint p, NSPoint cp);
NSPoint vhfPointAngleFromRefPoint(NSPoint cp, NSPoint refP, float angle);
float vhfAngleBetweenPoints(const NSPoint start, const NSPoint middle, const NSPoint end);	// ccw

int vhfSplitCurveAt(const NSPoint pc[4], float t, NSPoint *pc1, NSPoint *pc2);
BOOL vhfGetPointOnCurveAt(NSPoint *p, NSPoint pc[4], float t);
BOOL vhfGetGradientOfCurveAt(NSPoint *p, NSPoint pc[4], float t);
BOOL vhfConvertCurveToArc(NSPoint pc[4], NSPoint *center, NSPoint *start, float *angle);

#endif // VHF_H_2DFUNCTIONS
