/* main.m: Main Body of Cenon.app
 */
//#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

int main(int argc, const char *argv[])
//int main (void)
{ 
    NSDictionary	*infoDict;
    NSString		*className;
    Class		appClass;
    NSAutoreleasePool	*pool = [NSAutoreleasePool new];
    NSApplication	*app;

#if LIB_FOUNDATION_LIBRARY
    extern char		**environ;

    [NSProcessInfo initializeWithArguments:(char**)argv count:argc environment:environ];
#endif

#ifndef NX_CURRENT_COMPILER_RELEASE
//    initialize_gnustep_backend();
#endif

    infoDict = [[NSBundle mainBundle] infoDictionary];
    className = [infoDict objectForKey: @"NSPrincipalClass"];
    appClass = NSClassFromString(className);

    if (appClass == 0)
    {
        NSLog(@"Bad application class '%@' specified", className);
        appClass = [NSApplication class];
    }

    app = [appClass sharedApplication];
    [app setApplicationIconImage:[NSImage imageNamed:@"cenon.tiff"]];
    if(![NSBundle loadNibNamed:@"Main" owner:app])
        NSLog(@"Cannot load Main model file");

    [app run];
    [pool release];
    return 0;
}

